<?php
namespace Raven\Modules\Forms;

defined( 'ABSPATH' ) || die();

use Raven\Base\Module_base;
use Raven\Modules\Forms\Fields;
use Raven\Modules\Forms\Actions;
use Raven\Modules\Forms\Classes\Ajax_Handler;

class Module extends Module_Base {

	public static $field_types = [];

	public static $action_types = [];

	public static $messages = [];

	public function __construct() {
		parent::__construct();

		$this->register_field_types();

		$this->register_action_types();

		$this->set_messages();

		new Ajax_Handler();
	}

	public function get_widgets() {
		return [ 'form' ];
	}

	private function register_field_types() {
		$field_types = [
			'text',
			'email',
			'textarea',
			'tel',
			'number',
			'acceptance',
			'recaptcha',
		];

		foreach ( $field_types as $field ) {
			$class_name = __NAMESPACE__ . '\Fields\\' . ucfirst( $field );

			self::$field_types[ $field ] = new $class_name();
		}
	}

	private function register_action_types() {
		$action_types = [
			'email',
			'mailchimp',
			'redirect',
		];

		foreach ( $action_types as $action ) {
			$class_name = __NAMESPACE__ . '\Actions\\' . ucfirst( $action );

			self::$action_types[ $action ] = new $class_name();
		}
	}

	public function set_messages() {
		self::$messages = [
			'success' => 'The form was sent successfully!',
			'error' => 'Please check the errors.',
			'required' => 'Required',
			'subscriber' => 'Subscriber already exists.',
		];
	}

	public static function render_field( $widget, $field ) {
		self::$field_types[ $field['type'] ]->render( $widget, $field );
	}

	public static function find_element_recursive( $elements, $form_id ) {
		foreach ( $elements as $element ) {
			if ( $form_id === $element['id'] ) {
				return $element;
			}

			if ( ! empty( $element['elements'] ) ) {
				$element = self::find_element_recursive( $element['elements'], $form_id );

				if ( $element ) {
					return $element;
				}
			}
		}

		return false;
	}
}
