<?php

$general_section[] = array(
    "type" => "sub_group",
    "id" => "mk_options_footer",
    "name" => __("General / Footer", "mk_framework") ,
    "desc" => __("", "mk_framework") ,
    "fields" => array(
        array(
            "name" => __("Footer", "mk_framework") ,
            "desc" => __("Display footer section?", "mk_framework") ,
            "id" => "disable_footer",
            "default" => 'true',
            "type" => "toggle",
        ) ,
        array(
            "name" => __("Boxed Footer?", "mk_framework") ,
            "desc" => __("Enable boxed footer? The footer content will be in main grid (the width is defined in theme general settings), otherwise it will be fullwdith screen wide.", "mk_framework") ,
            "id" => "boxed_footer",
            "default" => 'true',
            "type" => "toggle",
        ) ,
        array(
            "name" => __("Disable on Mobile?", "mk_framework") ,
            "desc" => __("", "mk_framework") ,
            "id" => "footer_disable_mobile",
            "default" => 'false',
            "type" => "toggle",
        ) ,
        array(
            "name" => __("Footer Column Gutter Space", "mk_framework") ,
            "desc" => __("Adjust spacing between columns.", "mk_framework") ,
            "id" => "footer_gutter",
            "default" => "2",
            "min" => "0",
            "max" => "15",
            "step" => "1",
            "unit" => '%',
            "type" => "range",
        ) ,
        array(
            "name" => __("Footer Padding Bottom/Top", "mk_framework") ,
            "desc" => __("", "mk_framework") ,
            "id" => "footer_wrapper_padding",
            "default" => "30",
            "min" => "0",
            "max" => "250",
            "step" => "1",
            "unit" => 'px',
            "type" => "range",
        ) ,
        array(
            "name" => __("Footer Widget Margin Bottom", "mk_framework") ,
            "desc" => __("", "mk_framework") ,
            "id" => "footer_widget_margin_bottom",
            "default" => "40",
            "min" => "0",
            "max" => "200",
            "step" => "1",
            "unit" => 'px',
            "type" => "range",
        ) ,
        array(
            
            "name" => __("Footer Type", "mk_framework") ,
            "desc" => __("Choose a footer type. Fixed footer should not be used in boxed layout.", "mk_framework") ,
            "id" => "footer_type",
            "default" => '1',
            "options" => array(
                "1" => __('Regular', "mk_framework") ,
                "2" => __('Fixed', "mk_framework") ,
            ) ,
            "type" => "radio",
        ) ,
        array(
            "name" => __("Footer Column layout", "mk_framework") ,
            "id" => "footer_columns",
            "default" => "4",
            "item_padding" => "30px 30px 0 0",
            "options" => array(
                "1" => 'column_1.png',
                "2" => 'column_2.png',
                "3" => 'column_3.png',
                "4" => 'column_4.png',
                "5" => 'column_5.png',
                "6" => 'column_6.png',
                "half_sub_half" => 'column_half_sub_half.png',
                "half_sub_third" => 'column_half_sub_third.png',
                "third_sub_third" => 'column_third_sub_third.png',
                "third_sub_fourth" => 'column_third_sub_fourth.png',
                "sub_half_half" => 'column_sub_half_half.png',
                "sub_third_half" => 'column_sub_third_half.png',
                "sub_third_third" => 'column_sub_third_third.png',
                "sub_fourth_third" => 'column_sub_fourth_third.png',
            ) ,
            "type" => "visual_selector",
        ) ,
        array(
            "name" => __("Sub Footer", "mk_framework") ,
            "desc" => __("Display a sub footer section at the bottom of footer?", "mk_framework") ,
            "id" => "disable_sub_footer",
            "default" => 'true',
            "type" => "toggle",
        ) ,
        array(
            "name" => __("Sub Footer Navigation", "mk_framework"),
            "desc" => __("Display a custom navigation on the left section of sub footer.", "mk_framework") ,
            "id" => "enable_footer_nav",
            "default" => 'true',
            "type" => "toggle",
        ) ,
        
        array(
            "name" => __("Sub Footer Copyright Text", "mk_framework") ,
            "desc" => "",
            "id" => "copyright",
            "default" => 'Copyright All Rights Reserved &copy; 2017',
            "type" => "textarea",
        ) ,
    ) ,
);