<?php
vc_map(
	array(
		'name' => __( 'Portfolio Carousel', 'jupiter-donut' ),
		'base' => 'mk_portfolio_carousel',
		'html_template' => dirname( __FILE__ ) . '/mk_portfolio_carousel.php',
		'icon' => 'icon-mk-portfolio-carousel vc_mk_element-icon',
		'category' => __( 'Loops', 'jupiter-donut' ),
		'description' => __( 'Shows Portfolio loop in carousel.', 'jupiter-donut' ),
		'params' => array(
			array(
				'heading' => __( 'Style', 'jupiter-donut' ),
				'description' => __( 'Select which style you would like to use.', 'jupiter-donut' ),
				'param_name' => 'style',
				'value' => array(
					__( 'Classic', 'jupiter-donut' ) => 'classic',
					__( 'Modern (Screen wide)', 'jupiter-donut' ) => 'modern',
				),
				'type' => 'dropdown',
			),
			array(
				'heading' => __( 'Hover Scenarios', 'jupiter-donut' ),
				'description' => __( 'This is what happens when user hovers over a portfolio item. Different animations and styles will be showed up on each scenario.', 'jupiter-donut' ),
				'param_name' => 'hover_scenarios',
				'value' => array(
					__( 'Slide Box', 'jupiter-donut' ) => 'slidebox',
					__( 'Fade Box', 'jupiter-donut' ) => 'fadebox',
					__( 'Zoom In Box', 'jupiter-donut' ) => 'zoomin',
					__( 'Zoom Out Box', 'jupiter-donut' ) => 'zoomout',
					__( 'Light Zoom In', 'jupiter-donut' ) => 'light-zoomin',
					__( '3D Cube', 'jupiter-donut' ) => 'cube',
					__( 'None (only link to the single portfolio page)', 'jupiter-donut' ) => 'none',
				),
				'type' => 'dropdown',
				'dependency' => array(
					'element' => 'style',
					'value' => array(
						'modern',
					),
				),
			),
			array(
				'type' => 'textfield',
				'heading' => __( 'Heading Title', 'jupiter-donut' ),
				'param_name' => 'title',
				'value' => '',
				'description' => __( '', 'jupiter-donut' ),
			),
			array(
				'type'        => 'autocomplete',
				'heading'     => __( 'View All Page', 'jupiter-donut' ),
				'param_name'  => 'view_all',
				'description' => __( 'Select the page you would like to navigate if [View All] link is clicked. Search for post ID or post title to get autocomplete suggestions', 'jupiter-donut' ),
				'dependency' => array(
					'element' => 'style',
					'value' => array(
						'classic',
					),
				),
			),
			array(
				'type' => 'textfield',
				'heading' => __( '[View All] Link Title', 'jupiter-donut' ),
				'param_name' => 'view_all_text',
				'value' => 'View All',
				'description' => __( '', 'jupiter-donut' ),
			),
			array(
				'type' => 'range',
				'heading' => __( 'How many Posts?', 'jupiter-donut' ),
				'param_name' => 'count',
				'value' => '10',
				'min' => '-1',
				'max' => '50',
				'step' => '1',
				'unit' => 'posts',
				'description' => __( 'How many Posts would you like to show? (-1 means unlimited)', 'jupiter-donut' ),
			),
			array(
				'type' => 'range',
				'heading' => __( 'Visible Items at Once', 'jupiter-donut' ),
				'param_name' => 'show_items',
				'value' => '4',
				'min' => '1',
				'max' => '10',
				'step' => '1',
				'unit' => 'items',
				'description' => __( 'How many items you would like to show in carousel?', 'jupiter-donut' ),
				'dependency' => array(
					'element' => 'style',
					'value' => array(
						'modern',
					),
				),
			),
			array(
				'type' => 'range',
				'heading' => __( 'Offset', 'jupiter-donut' ),
				'param_name' => 'offset',
				'value' => '0',
				'min' => '0',
				'max' => '50',
				'step' => '1',
				'unit' => 'posts',
				'description' => __( 'Number of post to displace or pass over, it means based on your order of the loop, this number will define how many posts to pass over and start from the nth number of the offset.', 'jupiter-donut' ),
			),
			array(
				'heading' => __( 'Image Size', 'jupiter-donut' ),
				'description' => __( '', 'jupiter-donut' ),
				'param_name' => 'image_size',
				'value' => mk_get_image_sizes(),
				'type' => 'dropdown',
			),
			array(
				'type'        => 'autocomplete',
				'heading'     => __( 'Select specific Categories', 'jupiter-donut' ),
				'param_name'  => 'categories',
				'settings' => array(
					'multiple' => true,
					'sortable' => true,
					'unique_values' => true,
				),
				'description' => __( 'Search for category name to get autocomplete suggestions', 'jupiter-donut' ),
			),
			array(
				'type'        => 'autocomplete',
				'heading'     => __( 'Select specific Posts', 'jupiter-donut' ),
				'param_name'  => 'posts',
				'settings' => array(
					'multiple' => true,
					'sortable' => true,
					'unique_values' => true,
				),
				'description' => __( 'Search for post ID or post title to get autocomplete suggestions', 'jupiter-donut' ),
			),

			array(
				'type'        => 'autocomplete',
				'heading'     => __( 'Select specific Authors', 'jupiter-donut' ),
				'param_name'  => 'author',
				'settings' => array(
					'multiple' => true,
					'sortable' => true,
					'unique_values' => true,
				),
				'description' => __( 'Search for user ID, Username, Email Address to get autocomplete suggestions', 'jupiter-donut' ),
			),
			array(
				'type' => 'range',
				'heading' => __( 'Animation Speed', 'jupiter-donut' ),
				'param_name' => 'animation_speed',
				'value' => '400',
				'min' => '100',
				'max' => '3000',
				'step' => '1',
				'unit' => 'ms',
				'description' => __( '', 'jupiter-donut' ),
			),
			array(
				'type' => 'range',
				'heading' => __( 'Slideshow Speed', 'jupiter-donut' ),
				'param_name' => 'slideshow_speed',
				'value' => '5000',
				'min' => '1000',
				'max' => '90000',
				'step' => '1',
				'unit' => 'ms',
				'description' => __( '', 'jupiter-donut' ),
			),
			array(
				'type' => 'toggle',
				'heading' => __( 'Pause on Hover', 'jupiter-donut' ),
				'param_name' => 'pause_on_hover',
				'value' => 'false',
				'description' => __( 'Pauses the slideshow when hovering over slider, then resume when no longer hovering', 'jupiter-donut' ),
			),
			array(
				'heading' => __( 'Order', 'jupiter-donut' ),
				'description' => __( "Designates the ascending or descending order of the 'orderby' parameter.", 'jupiter-donut' ),
				'param_name' => 'order',
				'value' => array(
					__( 'DESC (descending order)', 'jupiter-donut' ) => 'DESC',
					__( 'ASC (ascending order)', 'jupiter-donut' ) => 'ASC',
				),
				'type' => 'dropdown',
			),
			array(
				'heading' => __( 'Orderby', 'jupiter-donut' ),
				'description' => __( 'Sort retrieved Portfolio items by parameter.', 'jupiter-donut' ),
				'param_name' => 'orderby',
				'value' => $mk_orderby,
				'type' => 'dropdown',
			),
			$add_device_visibility,
			array(
				'type' => 'textfield',
				'heading' => __( 'Extra class name', 'jupiter-donut' ),
				'param_name' => 'el_class',
				'value' => '',
				'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in Custom CSS Shortcode or Masterkey Custom CSS option.', 'jupiter-donut' ),
			),
		),
	)
);
