<?php
/**
 * Add form textarea field.
 *
 * @package Raven
 * @since 1.0.0
 */

namespace Raven\Modules\Forms\Fields;

defined( 'ABSPATH' ) || die();

use Elementor\Plugin as Elementor;

/**
 * Textarea Field.
 *
 * Initializing the textarea field by extending field base abstract class.
 *
 * @since 1.0.0
 */
class Textarea extends Field_Base {

	/**
	 * Render content.
	 *
	 * Render the field content.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function render_content() {
		?>
		<textarea
			<?php echo $this->widget->get_render_attribute_string( 'field-' . $this->get_id() ); ?>
			rows="<?php echo $this->field['rows']; ?>"></textarea>
		<?php
	}

	/**
	 * Update controls.
	 *
	 * Add Rows control in form fields.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @param object $widget Widget instance.
	 */
	public function update_controls( $widget ) {
		$control_data = Elementor::$instance->controls_manager->get_control_from_stack(
			$widget->get_unique_name(),
			'fields'
		);

		if ( is_wp_error( $control_data ) ) {
			return;
		}

		$field_controls = [
			'rows' => [
				'name' => 'rows',
				'label' => __( 'Rows', 'raven' ),
				'type' => 'number',
				'default' => 5,
				'condition' => [
					'type' => 'textarea',
				],
			],
		];

		$control_data['fields'] = $this->inject_field_controls( $control_data['fields'], $field_controls );
		$widget->update_control( 'fields', $control_data );
	}

}
