<?php

namespace WPML\SL;

class CustomFields implements \IWPML_Backend_Action, \IWPML_DIC_Action {

	/**
	 * @var array
	 */
	private $metaKeys;

	/**
	 * @var \AbsoluteLinks
	 */
	private $absoluteLinks;

	/**
	 * Class constructor.
	 *
	 * @param \AbsoluteLinks $absoluteLinks
	 */
	public function __construct( \AbsoluteLinks $absoluteLinks ) {
		$this->absoluteLinks = $absoluteLinks;
	}

	/**
	 * Add hooks.
	 */
	public function add_hooks() {
		add_action( 'updated_post_meta', [ $this, 'convertUrlsInCustomFields' ], 10, 4 );
		add_action( 'added_post_meta', [ $this, 'convertUrlsInCustomFields' ], 10, 4 );
	}

	/**
	 * Remove hooks.
	 */
	private function removeHooks() {
		remove_action( 'updated_post_meta', [ $this, 'convertUrlsInCustomFields' ], 10 );
		remove_action( 'added_post_meta', [ $this, 'convertUrlsInCustomFields' ], 10 );
	}

	/**
	 * Convert links to default format in the custom fields configured to do so.
	 *
	 * @param int    $metaId The primary key (not used here).
	 * @param int    $id     The post ID we are updating.
	 * @param string $key    The custom field we are updating.
	 * @param string $value  The value of the custom field.
	 */
	public function convertUrlsInCustomFields( $metaId, $id, $key, $value ) {
		$metaKeys = $this->getSettings();

		if ( false === in_array( $key, $metaKeys, true ) ) {
			return;
		}

		$alpBrokenLinks = [];
		$newValue       = $this->recursively_process_generic_text( $value, $alpBrokenLinks );

		if ( $newValue !== $value ) {
			$this->removeHooks();
			update_post_meta( $id, $key, $newValue, $value );
			$this->add_hooks();
		}
	}

	/**
	 * Recursively process custom field contents to convert links.
	 *
	 * @param mixed $value
	 * @param array $alpBrokenLinks
	 */
	private function recursively_process_generic_text( $value, &$alpBrokenLinks ) {
		if ( is_array( $value ) ) {
			foreach ( $value as $key => $row ) {
				$value[ $key ] = $this->recursively_process_generic_text( $row, $alpBrokenLinks );
			}
		} elseif ( is_string( $value ) ) {
			$value = $this->absoluteLinks->_process_generic_text( $value, $alpBrokenLinks );
		}

		return $value;
	}

	/**
	 * Gets a list of custom fields that are configured as `convert_to_sticky`.
	 *
	 * @return array
	 */
	private function getSettings() {
		if ( null === $this->metaKeys ) {
			$this->metaKeys = [];
			$settings       = apply_filters( 'wpml_setting', false, 'translation-management' );
			if ( array_key_exists( 'custom_fields_convert_to_sticky', $settings ) ) {
				$this->metaKeys = $settings['custom_fields_convert_to_sticky'];
			}
		}

		return $this->metaKeys;
	}

}
