<?php
namespace Raven\Modules\Products\Skins;

defined( 'ABSPATH' ) || die();

use Raven\Modules\Products\Module;

class Classic extends \Elementor\Skin_Base {

	public function get_id() {
		return 'classic';
	}

	public function get_title() {
		return __( 'Classic', 'raven' );
	}

	protected function _register_controls_actions() {
		add_action( 'elementor/element/raven-wc-products/section_settings/after_section_start', [ $this, 'settings_start_controls' ] );
		add_action( 'elementor/element/raven-wc-products/section_settings/before_section_end', [ $this, 'settings_end_controls' ] );
		add_action( 'elementor/element/raven-wc-products/section_sort_filter/after_section_end', [ $this, 'sort_filter_completed_controls' ] );
	}

	public function settings_start_controls( \Elementor\Widget_Base $widget ) {
		$this->parent = $widget;

		$this->add_control(
			'layout',
			[
				'label' => __( 'Layout', 'raven' ),
				'type' => 'select',
				'default' => 'grid',
				'options' => [
					'grid' => __( 'Grid', 'raven' ),
				],
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'columns',
			[
				'label' => __( 'Columns', 'raven' ),
				'type' => 'select',
				'default' => '3',
				'options' => [
					'1' => __( '1', 'raven' ),
					'2' => __( '2', 'raven' ),
					'3' => __( '3', 'raven' ),
					'4' => __( '4', 'raven' ),
					'5' => __( '5', 'raven' ),
					'6' => __( '6', 'raven' ),
				],
				'frontend_available' => true,
				'render_type' => 'template',
			]
		);

		$this->add_control(
			'rows',
			[
				'label' => __( 'Rows', 'raven' ),
				'type' => 'select',
				'default' => '3',
				'options' => [
					'1' => __( '1', 'raven' ),
					'2' => __( '2', 'raven' ),
					'3' => __( '3', 'raven' ),
					'4' => __( '4', 'raven' ),
					'5' => __( '5', 'raven' ),
					'6' => __( '6', 'raven' ),
				],
				'frontend_available' => true,
				'render_type' => 'template',
			]
		);
	}

	public function settings_end_controls( \Elementor\Widget_Base $widget ) {
		$this->parent = $widget;

		$this->add_control(
			'show_pagination',
			[
				'label' => __( 'Pagination', 'raven' ),
				'type' => 'switcher',
				'default' => '',
				'label_on' => __( 'Show', 'raven' ),
				'label_off' => __( 'Hide', 'raven' ),
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'pagination_type',
			[
				'label' => __( 'View Pagination As', 'raven' ),
				'type' => 'select',
				'default' => 'page_based',
				'options' => [
					'page_based' => __( 'Page Based', 'raven' ),
					'load_more' => __( 'Load More', 'raven' ),
					'infinite_load' => __( 'Infinite Load', 'raven' ),
				],
				'condition' => [
					$this->get_control_id( 'show_pagination' ) => 'yes',
				],
				'frontend_available' => true,
			]
		);
	}

	public function sort_filter_completed_controls( \Elementor\Widget_Base $widget ) {
		$this->parent = $widget;

		$this->start_controls_section(
			'section_pagination',
			[
				'label' => __( 'Pagination', 'raven' ),
				'tab' => 'style',
				'condition' => [
					$this->get_control_id( 'show_pagination' ) => 'yes',
					$this->get_control_id( 'pagination_type!' ) => [ '', 'infinite_load', 'page_based' ],
				],
			]
		);

		$this->load_more_controls();

		$this->end_controls_section();
	}

	/**
	 *
	 * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
	 */
	protected function load_more_controls() {
		$load_more_condition = [
			$this->get_control_id( 'pagination_type' ) => 'load_more',
		];

		$this->add_control(
			'load_more_text',
			[
				'label' => __( 'Button Label', 'raven' ),
				'type' => 'text',
				'default' => __( 'Load More', 'raven' ),
				'condition' => $load_more_condition,
			]
		);

		$this->add_responsive_control(
			'load_more_width',
			[
				'label' => __( 'Width', 'raven' ),
				'type' => 'slider',
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
					'unit' => 'px',
				],
				'tablet_default' => [
					'unit' => 'px',
				],
				'mobile_default' => [
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 1000,
					],
				],
				'condition' => $load_more_condition,
				'selectors' => [
					'{{WRAPPER}} .raven-load-more-button' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'load_more_height',
			[
				'label' => __( 'Height', 'raven' ),
				'type' => 'slider',
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
					'unit' => 'px',
				],
				'tablet_default' => [
					'unit' => 'px',
				],
				'mobile_default' => [
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 1000,
					],
				],
				'condition' => $load_more_condition,
				'selectors' => [
					'{{WRAPPER}} .raven-load-more-button' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'load_more_padding',
			[
				'label' => __( 'Padding', 'raven' ),
				'type' => 'dimensions',
				'size_units' => [ 'px', '%' ],
				'condition' => $load_more_condition,
				'selectors' => [
					'{{WRAPPER}} .raven-load-more-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'load_more_align',
			[
				'label' => __( 'Alignment', 'raven' ),
				'type' => 'choose',
				'default' => '',
				'options' => [
					'left' => [
						'title' => __( 'Left', 'raven' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'raven' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'raven' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'condition' => $load_more_condition,
				'selectors' => [
					'{{WRAPPER}} .raven-load-more' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->start_controls_tabs( 'tabs_load_more' );

		$this->start_controls_tab(
			'tabs_load_more_normal',
			[
				'label' => __( 'Normal', 'raven' ),
				'condition' => $load_more_condition,
			]
		);

		$this->add_control(
			'load_more_color',
			[
				'label' => __( 'Color', 'raven' ),
				'type' => 'color',
				'condition' => $load_more_condition,
				'selectors' => [
					'{{WRAPPER}} .raven-load-more-button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			'typography',
			[
				'name' => 'load_more_typography',
				'scheme' => '3',
				'condition' => $load_more_condition,
				'selector' => '{{WRAPPER}} .raven-load-more-button',
			]
		);

		$this->add_group_control(
			'raven-background',
			[
				'name' => 'load_more_background',
				'exclude' => [ 'image' ],
				'fields_options' => [
					'background' => [
						'label' => __( 'Background Color Type', 'raven' ),
					],
					'color' => [
						'label' => __( 'Background Color', 'raven' ),
					],
				],
				'condition' => $load_more_condition,
				'selector' => '{{WRAPPER}} .raven-load-more-button',
			]
		);

		$this->add_control(
			'load_more_border_heading',
			[
				'label' => __( 'Border', 'raven' ),
				'type' => 'heading',
				'separator' => 'before',
				'condition' => $load_more_condition,
			]
		);

		$this->add_control(
			'load_more_border_color',
			[
				'label' => __( 'Color', 'raven' ),
				'type' => 'color',
				'condition' => [
					$this->get_control_id( 'load_more_border_border!' ) => '',
					$this->get_control_id( 'pagination_type' ) => 'load_more',
				],
				'selectors' => [
					'{{WRAPPER}} .raven-load-more-button' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			'border',
			[
				'name' => 'load_more_border',
				'placeholder' => '1px',
				'exclude' => [ 'color' ],
				'fields_options' => [
					'width' => [
						'label' => __( 'Border Width', 'raven' ),
					],
				],
				'condition' => $load_more_condition,
				'selector' => '{{WRAPPER}} .raven-load-more-button',
			]
		);

		$this->add_control(
			'load_more_border_radius',
			[
				'label' => __( 'Border Radius', 'raven' ),
				'type' => 'dimensions',
				'size_units' => [ 'px', '%' ],
				'default' => [
					'unit' => 'px',
				],
				'condition' => $load_more_condition,
				'selectors' => [
					'{{WRAPPER}} .raven-load-more-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			'box-shadow',
			[
				'name' => 'load_more_box_shadow',
				'condition' => $load_more_condition,
				'selector' => '{{WRAPPER}} .raven-load-more-button',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tabs_load_more_hover',
			[
				'label' => __( 'Hover', 'raven' ),
				'condition' => $load_more_condition,
			]
		);

		$this->add_control(
			'hover_load_more_color',
			[
				'label' => __( 'Color', 'raven' ),
				'type' => 'color',
				'condition' => $load_more_condition,
				'selectors' => [
					'{{WRAPPER}} .raven-load-more-button:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			'typography',
			[
				'name' => 'hover_load_more_typography',
				'scheme' => '3',
				'condition' => $load_more_condition,
				'selector' => '{{WRAPPER}} .raven-load-more-button:hover',
			]
		);

		$this->add_group_control(
			'raven-background',
			[
				'name' => 'hover_load_more_background',
				'exclude' => [ 'image' ],
				'fields_options' => [
					'background' => [
						'label' => __( 'Background Color Type', 'raven' ),
					],
					'color' => [
						'label' => __( 'Background Color', 'raven' ),
					],
				],
				'condition' => $load_more_condition,
				'selector' => '{{WRAPPER}} .raven-load-more-button:hover',
			]
		);

		$this->add_control(
			'hover_load_more_border_heading',
			[
				'label' => __( 'Border', 'raven' ),
				'type' => 'heading',
				'separator' => 'before',
				'condition' => $load_more_condition,
			]
		);

		$this->add_control(
			'hover_load_more_border_color',
			[
				'label' => __( 'Color', 'raven' ),
				'type' => 'color',
				'condition' => [
					$this->get_control_id( 'hover_load_more_border_border!' ) => '',
					$this->get_control_id( 'pagination_type' ) => 'load_more',
				],
				'selectors' => [
					'{{WRAPPER}} .raven-load-more-button:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			'border',
			[
				'name' => 'hover_load_more_border',
				'placeholder' => '1px',
				'exclude' => [ 'color' ],
				'fields_options' => [
					'width' => [
						'label' => __( 'Border Width', 'raven' ),
					],
				],
				'condition' => $load_more_condition,
				'selector' => '{{WRAPPER}} .raven-load-more-button:hover',
			]
		);

		$this->add_control(
			'hover_load_more_border_radius',
			[
				'label' => __( 'Border Radius', 'raven' ),
				'type' => 'dimensions',
				'size_units' => [ 'px', '%' ],
				'default' => [
					'unit' => 'px',
				],
				'condition' => $load_more_condition,
				'selectors' => [
					'{{WRAPPER}} .raven-load-more-button:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			'box-shadow',
			[
				'name' => 'hover_load_more_box_shadow',
				'condition' => $load_more_condition,
				'selector' => '{{WRAPPER}} .raven-load-more-button:hover',
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();
	}

	public function render() {
		$this->parent->query_posts();

		$query = $this->parent->query;

		if ( ! $query->have_posts() ) {
			return;
		}

		$paginated = ! $query->get( 'no_found_rows' );

		$wc_loop = [
			'is_paginated' => $paginated,
			'total' => $paginated ? (int) $query->found_posts : count( $query->posts ),
			'total_pages' => $paginated ? (int) $query->max_num_pages : 1,
			'per_page' => (int) $query->get( 'posts_per_page' ),
			'current_page' => $paginated ? (int) max( 1, $query->get( 'paged', 1 ) ) : 1,
		];

		wc_setup_loop( $wc_loop );

		$settings = array_merge( $wc_loop, [
			'pages_visible' => 7,
		] );

		?>
		<div class="raven-wc-products-wrapper" data-settings="<?php echo esc_attr( wp_json_encode( $settings ) ); ?>">
			<div class="woocommerce columns-<?php echo esc_attr( $this->get_instance_value( 'columns' ) ); ?>">
				<?php
				$this->render_products();
				$this->render_pagination();
				?>
			</div>
		</div>
		<?php
	}

	public function render_products( $echo = true ) {
		$data = [];

		$query = $this->parent->query;

		global $woocommerce_loop;

		$woocommerce_loop['columns'] = (int) $this->get_instance_value( 'columns' );

		add_filter( 'post_class', [ $this, 'add_product_post_class' ] );

		add_filter( 'woocommerce_product_is_visible', [ $this, 'set_product_as_visible' ] );

		if ( function_exists( 'jupiterx_wc_loop_elements_enabled' ) ) {
			jupiterx_wc_loop_elements_enabled();
		}

		if ( $echo ) :

			woocommerce_product_loop_start();

		endif;

		while ( $query->have_posts() ) :

			$query->the_post();

			if ( $echo ) :

				wc_get_template_part( 'content', 'product' );

			elseif ( ! $echo ) :

				ob_start();

				wc_get_template_part( 'content', 'product' );

				$data['products'][] = ob_get_clean();

			endif;

		endwhile;

		if ( $echo ) :

			woocommerce_product_loop_end();

		endif;

		woocommerce_reset_loop();

		remove_filter( 'post_class', [ $this, 'add_product_post_class' ] );

		remove_filter( 'woocommerce_product_is_visible', [ $this, 'set_product_as_visible' ] );

		wp_reset_postdata();

		return $data;
	}

	protected function render_pagination() {
		if ( ! $this->get_instance_value( 'show_pagination' ) ) {
			return;
		}

		$pagination_type = $this->get_instance_value( 'pagination_type' );

		switch ( $pagination_type ) {
			case 'load_more':
				$this->render_load_more();
				break;

			case 'page_based':
				echo '<nav class="woocommerce-pagination"></nav>';
				break;
		}
	}

	protected function render_load_more() {
		?>
		<div class="raven-load-more">
			<a class="raven-load-more-button" href="#">
				<span class="raven-post-button-text"><?php echo $this->get_instance_value( 'load_more_text' ); ?></span>
			</a>
		</div>
		<?php
	}

	public function add_product_post_class( $classes ) {
		$classes[] = 'product';

		return $classes;
	}

	public function set_product_as_visible() {
		return true;
	}
}
