<?php
/**
 * Filters the path for a specific filesystem method class file.
 *
 * @see get_filesystem_method()
 * @since 2.6.0
 *
 * @param string $path   Path to the specific filesystem method class file.
 * @param string $method The filesystem method to use.
 */
function wpsftp_filesystem_method_file( $abstraction_file, $method ) {
	if ( 'sftp' == $method ) {
		$abstraction_file = dirname(__FILE__) . '/class-wp-filesystem-sftp.php';
	}
	return $abstraction_file;
}
add_filter( 'filesystem_method_file', 'wpsftp_filesystem_method_file', 10, 2 );

/**
 * Filters the connection types to output to the filesystem credentials form.
 *
 *                            for being writable.
 *
 * @since 2.9.0
 * @since 4.6.0 The `$context` parameter default changed from `false` to an empty string.
 *
 * @param array  $types       Types of connections.
 * @param array  $credentials Credentials to connect with.
 * @param string $type        Chosen filesystem method.
 * @param object $error       Error object.
 * @param string $context     Full path to the directory that is tested
 */
function wpsftp_fs_ftp_connection_types( $types, $credentials, $type, $error, $context ) {
	if ( function_exists( 'stream_get_contents' ) ) {
		$types['sftp'] = __( 'SFTP' );
	}
	return $types;
}
add_filter( 'fs_ftp_connection_types', 'wpsftp_fs_ftp_connection_types', 10, 5 );

/**
 * Filters the filesystem method to use.
 *
 * @since 2.6.0
 *
 * @param string $method                       Filesystem method to return.
 * @param array  $args                         An array of connection details for the method.
 * @param string $context                      Full path to the directory that is tested for being writable.
 * @param bool   $allow_relaxed_file_ownership Whether to allow Group/World writable.
 */
function wpsftp_filesystem_method( $method, $args, $context, $allow_relaxed_file_ownership ) {

	if ( 'direct' == $method ){
		return $method;
	}

	if( ( defined('FS_METHOD') && 'sftp' == FS_METHOD ) || ( isset( $_REQUEST['connection_type'] ) && 'sftp' == $_REQUEST['connection_type'] ) ){
		$method = 'sftp';
	}
	return $method;
}
add_filter( 'filesystem_method', 'wpsftp_filesystem_method', 10, 4 );