<?php
global $product, $woocommerce_loop, $woocommerce, $mk_options, $post;
$product_rating = '';

if( ! class_exists( 'WooCommerce' ) ) {
	echo 'WooCommerce Plugin is not installed!';
	return false;
}

if ( ! vc_is_page_editable() ) {
	wp_enqueue_script( 'wc-add-to-cart-variation' );
}

$path = pathinfo(__FILE__) ['dirname'];

include ($path . '/config.php');

$id = uniqid();

do_action( 'woocommerce_before_single_product' );


$paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
switch ($display) {
	case 'recent':
	   $args = array(
		    'post_type'             => 'product',
		    'post_status'           => 'publish',
		    'ignore_sticky_posts'   => 1,
		    'posts_per_page'        => $count,
		    'orderby'               => 'date',
		    'order'                 => 'desc',
		    'paged'                 => $paged,
		    'meta_query'            => WC()->query->get_meta_query(),
		);
		break;

	case 'featured':
		/**
		 * Since WooCommerce 3.0, the featured query filter is included in tax_query terms.
		 *
		 * @since 5.9.8
		 * @see woocommerce/includes/class-wc-shortcodes.php
		 */
		$tax_query = WC()->query->get_tax_query();
		$tax_query[] = array(
			'taxonomy' => 'product_visibility',
			'field'    => 'name',
			'terms'    => 'featured',
			'operator' => 'IN',
		);

		$args = array(
		    'post_type'             => 'product',
		    'post_status'           => 'publish',
		    'ignore_sticky_posts'   => 1,
		    'posts_per_page'        => $count,
		    'orderby'               => 'date',
		    'order'                 => 'desc',
		    'paged'                 => $paged,
		    'meta_query'            => WC()->query->get_meta_query(),
			'tax_query'             => $tax_query,
		);
		break;

	case 'top_rated':
	   $args = array(
		    'post_type'             => 'product',
		    'post_status'           => 'publish',
		    'ignore_sticky_posts'   => 1,
		    'posts_per_page'        => $count,
		    'order'                 => $order,
		    'paged'                 => $paged,
		    'meta_key'       		=> '_wc_average_rating',
			'orderby'       	 	=> 'meta_value_num',
			'meta_query'     		=> WC()->query->get_meta_query(),
			'tax_query'      		=> WC()->query->get_tax_query(),
		);
		break;

	case 'products_on_sale':
	   $args = array(
		    'post_type'             => 'product',
		    'post_status'           => 'publish',
		    'ignore_sticky_posts'   => 1,
		    'posts_per_page'        => $count,
		    'orderby'               => $orderby,
		    'order'                 => $order,
		    'paged'                 => $paged,
		    'meta_query'            => WC()->query->get_meta_query(),
		    'post__in'					 => array_merge( array( 0 ), wc_get_product_ids_on_sale() ),
		);
		break;

	case 'best_sellings':
		$args = array(
		    'post_type'             => 'product',
		    'post_status'           => 'publish',
		    'ignore_sticky_posts'   => 1,
		    'posts_per_page'        => $count,
		    'orderby'               => 'meta_value_num',
		    'order'                 => $order,
		    'orderby'               => $orderby,
		    'paged'                 => $paged,
		    'meta_key'            	 => 'total_sales',
		    'meta_query'            => WC()->query->get_meta_query(),
		);
		break;
}

		if(!empty($category)) {
			$args['tax_query'] = array(
				array(
					'taxonomy' 		=> 'product_cat',
					'terms' 		=> array_map( 'sanitize_title', explode( ',', $category ) ),
					'field' 		=> 'slug',
				)
			);
		}

if (isset($posts) && !empty($posts)) {
    $args['post__in'] = explode(',', $posts);
}

$class[] = $layout.'-layout';
$class[] = $el_class;
$class[] = $visibility;

?>
<div id="mk-product-loop-<?php echo $id; ?>" class="mk-product-loop grid--float clear <?php echo implode(' ', $class); ?>">
	<section class="products js-el mk--row" data-mk-component="Grid" data-grid-config='{"item":".product"}'>
<?php

/**
 * Product Loop
 * ==================================================================================*/
$query = new WP_Query( $args );
if($query->have_posts()):
    while ( $query->have_posts() ) : $query->the_post();
		global $product;

		if ( ! $product->is_visible() ) {
			continue;
		}

        $product_id 		= get_the_ID();
        $uid 				= uniqid();
        $woocommerce_cat 	= $mk_options['woocommerce_catalog'];
        $grid_width 		= $mk_options['grid_width'];
        $content_width 		= $mk_options['content_width'];
        $height 			= $mk_options['woo_loop_img_height'];
        $product_type 		= $product->get_type();
        $hover_image_src 	= '';

        // thumbnail
        switch ($columns) {
		case 4:
			$column_class = 'mk--col--3-12';
			$image_width = round($grid_width/4) - 28;
		break;
		case 3:
			$column_class = 'mk--col--4-12';
			$image_width = round($grid_width/3) - 33;
		break;
		case 2:
			$column_class = 'mk--col--1-2';
			$image_width = round($grid_width/2) - 38;
		break;

		default:
			$column_class = 'mk--col--1-2';
			$image_width = round($grid_width/2) - 38;
		break;
	}

    if ( has_post_thumbnail() ) {

		$featured_image_src = Mk_Image_Resize::resize_by_id_adaptive( get_post_thumbnail_id(), $image_size, $image_width, $height, $crop = false, $dummy = true);

		$product_gallery = get_post_meta( $post->ID, '_product_image_gallery', true );

		if ( !empty( $product_gallery ) ) {
			$gallery = explode( ',', $product_gallery );
			$hover_image_id  = $gallery[0];
			$hover_image_src = Mk_Image_Resize::resize_by_id_adaptive($hover_image_id, $image_size, $image_width, $height, $crop = false, $dummy = true);
		}
	}


	// check product stock, add cart a tag url, add cart a tag label and add icon class
	if ( ! $product->is_in_stock() ) {
		$link  			= apply_filters( 'out_of_stock_add_to_cart_url', esc_url( get_permalink( $product->get_id() ) ) );
		$label  			= apply_filters( 'out_of_stock_add_to_cart_text', __( 'READ MORE', 'mk_framework' ) );
		$icon_class 		= 'mk-moon-search-3';
		$out_of_stock_badge = '<span class="out-of-stock"><span>'.__( 'Out of Stock', 'mk_framework' ).'</span></span>';
	}else {
		$out_of_stock_badge = '';
		switch ( $product->get_type() ) {
			case "variable" :
				$link  		= apply_filters( 'variable_add_to_cart_url', esc_url( get_permalink( $product->get_id() ) ) );
				$label  		= apply_filters( 'variable_add_to_cart_text', __( 'Select Options', 'mk_framework' ) );
				$icon_class 	= 'mk-icon-plus';
				break;
			case "grouped" :
				$link  		= apply_filters( 'grouped_add_to_cart_url', esc_url( get_permalink( $product->get_id() ) ) );
				$label  		= apply_filters( 'grouped_add_to_cart_text', __( 'View Options', 'mk_framework' ) );
				$icon_class 	= 'mk-moon-search-3';
				break;
			case "external" :
				$link 	 	= apply_filters( 'external_add_to_cart_url', esc_url( get_permalink( $product->get_id() ) ) );
				$label  		= apply_filters( 'external_add_to_cart_text', __( 'Read More', 'mk_framework' ) );
				$icon_class 	= 'mk-moon-search-3';
				break;
			default :
				$link  		= apply_filters( 'add_to_cart_url', esc_url( $product->add_to_cart_url() ) );
				$label  		= apply_filters( 'add_to_cart_text', __( 'Add to Cart', 'mk_framework' ) );
				$icon_class 	= 'mk-moon-cart-plus';
				break;
			}
	}

	// check product on sale
	if( $product->is_on_sale() ) {
		$sale_badge = apply_filters('woocommerce_sale_flash', '<span class="onsale"><span>'.__( 'Sale', 'mk_framework' ).'</span></span>', $post, $product);
	}else {
		$sale_badge = '';
	}
	if($mk_options['woocommerce_loop_show_desc'] == 'true') {
		$item_desc = apply_filters( 'woocommerce_short_description', $post->post_excerpt );
	}else {
		$item_desc = '';
	}

	if(version_compare(WC_VERSION, '3.0', '>=')) {
		$wc_category_list = wc_get_product_category_list($product->get_id(), ', ', '', '');
	} else {
		$wc_category_list = $product->get_categories(', ');
	}

	$shortcodeViewAtts = array(
		'product_id' 				=> $product_id,
		'product_type'				=> $product_type,
		'product_col' 				=> $column_class,
		'thumb_image' 				=> $featured_image_src,
		'thumb_title' 				=> get_the_title(),
		'thumb_hover_image' 		=> $hover_image_src,
		'show_quickview'			=> $show_quickview,
		'show_category'			=> $show_category,
		'show_rating'				=> $show_rating,
		'product_link' 			=> esc_url( get_permalink() ),
		'product_add_link' 		=> $link,
		'product_add_label' 		=> $label,
		'product_add_icon' 		=> $icon_class,
		'out_of_stock_badge' 	=> $out_of_stock_badge,
		'sale_of_stock_badge' 	=> $sale_badge,
		'item_desc'					=> $item_desc,
		'category_name'			=> $wc_category_list,
		'animation'					=> $animation,
	);


        echo mk_get_shortcode_view( 'mk_products',  'loop-styles/product-loop-' . $layout,  true,  $shortcodeViewAtts );

        $shortcodeViewAtts = array();

    endwhile;
    wp_reset_postdata();
endif;

?>
</section>

<?php if ($pagination != 'false') { ?>
	<nav class="woocommerce-pagination">
		<?php
			echo paginate_links( apply_filters( 'woocommerce_pagination_args', array(
				'base'         => esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) ),
				'format'       => '',
				'add_args'     => false,
				'current'      => max( 1, get_query_var( 'paged' ) ),
				'total'        => $query->max_num_pages,
				'prev_text'    => '&larr;',
				'next_text'    => '&rarr;',
				'type'         => 'list',
				'end_size'     => 3,
				'mid_size'     => 3,
			) ) );
		?>
	</nav>
<?php }?>
</div>


<?php
/**
 * Custom CSS Output
 * ==================================================================================*/
if(!empty($color_product_title)) {	
	Mk_Static_Files::addCSS('
		#mk-product-loop-'.$id.' .product-title,
		#mk-product-loop-'.$id.' .product-title a,
		#mk-product-loop-'.$id.' .mk-love-holder a .mk-love-count {
			color: '.$color_product_title.';
		}
		#mk-product-loop-'.$id.' .mk-love-holder svg {
			fill: '.$color_product_title.';
		}
		#mk-product-loop-'.$id.'.open-layout .mk-love-holder .mk-love-this{
			border: 2px solid '.$color_product_title.';
		}
	', $id);
}

if(!empty($color_product_category)) {	
	Mk_Static_Files::addCSS('
		#mk-product-loop-'.$id.' .product-categories,
		#mk-product-loop-'.$id.' .product-categories a {
			color: '.$color_product_category.';
		}
	', $id);
}

if(!empty($color_product_rating)) {	
	Mk_Static_Files::addCSS('
		#mk-product-loop-'.$id.' .star-rating span:before {
			color: '.$color_product_rating.' !important;
		}
	', $id);
}

if(!empty($color_product_price)) {	
	Mk_Static_Files::addCSS('
		#mk-product-loop-'.$id.' .price .amount {
			color: '.$color_product_price.';
		}
	', $id);
}

if(!empty($color_product_price_orginal)) {	
	Mk_Static_Files::addCSS('
		#mk-product-loop-'.$id.' .price del .amount {
			color: '.$color_product_price_orginal.';
		}
	', $id);
}

if(!empty($color_product_price_sale)) {	
	Mk_Static_Files::addCSS('
		#mk-product-loop-'.$id.' .price ins .amount {
			color: '.$color_product_price_sale.';
		}
	', $id);
}

if($color_product_border != '') {
	Mk_Static_Files::addCSS('
		#mk-product-loop-'.$id.' .products .mk-product-holder .product-link{
			border: 1px solid '.$color_product_border.';
		}
	', $id);
}

if( $layout == 'open' ) {
	Mk_Static_Files::addCSS('
		.product-quick-view {
			max-width: '.$mk_options['grid_width'].'px;
		}
	', $id);
}
