<?php

vc_map(array(
	'name' => __( 'Gradient Button', 'jupiter-donut' ),
	'base' => 'mk_button_gradient',
	'html_template' => dirname( __FILE__ ) . '/mk_button_gradient.php',
	'category' => __( 'General', 'jupiter-donut' ),
	'icon' => 'icon-mk-button vc_mk_element-icon',
	'description' => __( 'Powerful & versatile button shortcode', 'jupiter-donut' ),
	'params' => array(
		array(
			'type' => 'dropdown',
			'heading' => __( 'Style', 'jupiter-donut' ),
			'param_name' => 'dimension',
			'value' => array(
				__( '2D', 'jupiter-donut' ) => 'two',
				__( 'Flat', 'jupiter-donut' ) => 'flat',
				__( 'Outline', 'jupiter-donut' ) => 'outline',
				__( 'Double Outline ', 'jupiter-donut' ) => 'double-outline',
			),
		) ,
		array(
			'type' => 'textarea',
			'holder' => 'div',
			'heading' => __( 'Button Text', 'jupiter-donut' ),
			'param_name' => 'content',
			'rows' => 1,
			'value' => '',
		) ,
		array(
			'type' => 'dropdown',
			'heading' => __( 'Size', 'jupiter-donut' ),
			'param_name' => 'size',
			'value' => array(
				'Small' => 'small',
				'Medium' => 'medium',
				'Large' => 'large',
				'X-Large' => 'x-large',
				'XX-Large' => 'xx-large',
			),
		) ,
		array(
			'type' => 'dropdown',
			'heading' => __( 'Corner style', 'jupiter-donut' ),
			'param_name' => 'corner_style',
			'value' => array(
				'Pointed' => 'pointed',
				'Rounded' => 'rounded',
				'Full Rounded' => 'full_rounded',
			),
			'description' => __( 'How will your button corners look like?', 'jupiter-donut' ),
			'dependency' => array(
				'element' => 'dimension',
				'value' => array(
					'two',
					'flat',
				),
			),
		) ,
		array(
			'type' => 'alpha_colorpicker',
			'heading' => __( 'From', 'jupiter-donut' ),
			'param_name' => 'grandient_color_from',
			'edit_field_class' => 'vc_col-sm-3 vc_column',
			'value' => '',
		) ,
		array(
			'type' => 'alpha_colorpicker',
			'heading' => __( 'To', 'jupiter-donut' ),
			'param_name' => 'grandient_color_to',
			'edit_field_class' => 'vc_col-sm-3 vc_column',
			'value' => '',
		) ,
		array(
			'type' => 'dropdown',
			'heading' => __( 'Style', 'jupiter-donut' ),
			'param_name' => 'grandient_color_style',
			'edit_field_class' => 'vc_col-sm-3 vc_column',
			'value' => array(
				__( 'Linear', 'jupiter-donut' ) => 'linear',
				__( 'Radial', 'jupiter-donut' ) => 'radial',
			),
		) ,
		array(
			'type' => 'dropdown',
			'heading' => __( 'Angle', 'jupiter-donut' ),
			'param_name' => 'grandient_color_angle',

			'edit_field_class' => 'vc_col-sm-3 vc_column',
			'value' => array(
				__( 'Vertical ↓', 'jupiter-donut' ) => 'vertical',
				__( 'Horizontal →', 'jupiter-donut' ) => 'horizontal',
				__( 'Diagonal ↘', 'jupiter-donut' ) => 'diagonal_left_bottom',
				__( 'Diagonal ↗', 'jupiter-donut' ) => 'diagonal_left_top',
			),
			'dependency' => array(
				'element' => 'grandient_color_style',
				'value' => array(
					'linear',
				),
			),
		) ,
		array(
			'type' => 'alpha_colorpicker',
			'heading' => __( 'Gradient Fallback Color', 'jupiter-donut' ),
			'param_name' => 'grandient_color_fallback',
			'value' => '',
		) ,
		array(
			'type' => 'dropdown',
			'heading' => __( 'Button Text Color', 'jupiter-donut' ),
			'param_name' => 'text_color',
			'width' => 150,
			'value' => array(
				__( 'Light', 'jupiter-donut' ) => 'light',
				__( 'Dark', 'jupiter-donut' ) => 'dark',
			),
		) ,
		array(
			'type' => 'textfield',
			'heading' => __( 'Button URL', 'jupiter-donut' ),
			'param_name' => 'url',
			'value' => '',
		) ,
		array(
			'type' => 'autocomplete',
			'heading' => __( 'Select Specific Product', 'jupiter-donut' ),
			'param_name' => 'product_id',
			'settings' => array(
				'multiple' => false,
				'sortable' => false,
				'unique_values' => true,
			),
			'description' => __( 'Search for product ID/title to get autocomplete suggestions', 'jupiter-donut' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => __( 'Target', 'jupiter-donut' ),
			'param_name' => 'target',
			'width' => 200,
			'value' => $target_arr,
		) ,
		array(
			'type' => 'dropdown',
			'heading' => __( 'Align', 'jupiter-donut' ),
			'param_name' => 'align',
			'width' => 150,
			'value' => array(
				__( 'Left', 'jupiter-donut' ) => 'left',
				__( 'Right', 'jupiter-donut' ) => 'right',
				__( 'Center', 'jupiter-donut' ) => 'center',
				__( 'None', 'jupiter-donut' ) => 'none',
			),
		) ,
		array(
			'type' => 'toggle',
			'heading' => __( 'Full Width button?', 'jupiter-donut' ),
			'param_name' => 'fullwidth',
			'value' => 'false',
			'description' => __( 'Using this option you can make the button full width and cover one row.', 'jupiter-donut' ),
		) ,
		array(
			'type' => 'range',
			'heading' => __( 'Custom Button Width', 'jupiter-donut' ),
			'param_name' => 'button_custom_width',
			'value' => '0',
			'min' => '0',
			'max' => '1500',
			'step' => '1',
			'unit' => 'px',
			'dependency' => array(
				'element' => 'fullwidth',
				'value' => array(
					'false',
				),
			),
		) ,
		array(
			'type' => 'textfield',
			'heading' => __( 'Button ID', 'jupiter-donut' ),
			'param_name' => 'id_second',
			'value' => '',
			'description' => __( 'If your want to use id for this button to refer it in your custom JS, fill this textbox.', 'jupiter-donut' ),
		) ,
		array(
			'type' => 'range',
			'heading' => __( 'Margin Top', 'jupiter-donut' ),
			'param_name' => 'margin_top',
			'value' => '0',
			'min' => '-30',
			'max' => '500',
			'step' => '1',
			'unit' => 'px',
		) ,
		array(
			'type' => 'range',
			'heading' => __( 'Margin Bottom', 'jupiter-donut' ),
			'param_name' => 'margin_bottom',
			'value' => '15',
			'min' => '-30',
			'max' => '500',
			'step' => '1',
			'unit' => 'px',
		) ,
		array(
			'type' => 'range',
			'heading' => __( 'Margin Right', 'jupiter-donut' ),
			'param_name' => 'margin_right',
			'value' => '15',
			'min' => '0',
			'max' => '500',
			'step' => '1',
			'unit' => 'px',
		) ,
		$add_css_animations,
		$add_device_visibility,
		array(
			'type' => 'textfield',
			'heading' => __( 'Extra class name', 'jupiter-donut' ),
			'param_name' => 'el_class',
			'value' => '',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in Custom CSS Shortcode or Masterkey Custom CSS option.', 'jupiter-donut' ),
		),
	),
));
